const defaultscopeValue = 0;
const picturescopeValue = 1;
const picturescopeName = "picture";
const vectorscopeValue = 2;
const vectorscopeName = "vectorscope";
const waveformscopeValue = 3;
const waveformscopeName = "waveform";
const waveformrgbscopeValue = 4;
const waveformrgbscopeName = "waveformrgb";
const histogramscopeValue = 6;
const histogramscopeName = "histogram";
const chromaticityscopeValue = 7;
const chromaticityscopeName = "chromaticity";
const statusscopeValue = 12;
const statusscopeName = "status";

const ycbcrvectorValue = 22;
const ycbcrvectorName = "ycbcrvector";
const channelplotValue = 23;
const channelplotName = "channelplot";
const ycpeakValue = 24;
const ycpeakName = "ycpeak";
const lumaqvectorValue = 25;
const lumaqvectorName = "lumaqvector";
const threedcolorcubeValue = 26;
const threedcolorcubeName = "3dcolorcube";

const lumapeakValue = 29;
const lumapeakName = "lumapeak";

const sixbargamutValue = 30;
const sixbargamutName = "sixbargamut";

const audiospectrumValue = 128;
const audiospectrumName = "audiospectrum";

const ancscopeValue = 18;
const ancscopeName = "ancdisplay";
const timingscopeValue = 17;
const timingscopeName = "iptiming";
const audiovectorscopeValue = 130;
const audiovectorscopeName = "audiovectorscope";
const audiophasescopeValue = 131;
const audiophasescopeName = "audiophase";
const audiohistogramscopeValue = 132;
const audiohistogramscopeName = "audiohistogram";
const audiowavescopeValue = 262144;
const audiowavescopeName = "audiowave";
const audiometerscopeValue = 19;
const audiometerscopeName = "audiometer";
const audiometerssurroundscopeValue = 20;
const audiometerssurroundscopeName = "audiometerssurround";
const audiometersloudnessscopeValue = 21;
const audiometersloudnessscopeName = "audiometersloudnesss";

const avsyncValue = 31;
const avsyncName = "avsync";
const streamInfoValue = 32;
const streamInfoName = "stream";

function scopeValueToName(scopeValue) {
    var scopeName = "";
    //Get scope name

    if (scopeValue == picturescopeValue || scopeValue == defaultscopeValue) {
        scopeName = picturescopeName;
    }
    else if (scopeValue == vectorscopeValue) {
        scopeName = vectorscopeName;
    }
    else if (scopeValue == waveformscopeValue) {
        scopeName = waveformscopeName;
    }
    else if (scopeValue == waveformrgbscopeValue) {
        scopeName = waveformrgbscopeName;
    }
    else if (scopeValue == histogramscopeValue) {
        scopeName = histogramscopeName;
    }
    else if (scopeValue == chromaticityscopeValue) {
        scopeName = chromaticityscopeName;
    }
    else if (scopeValue == statusscopeValue) {
        scopeName = statusscopeName;
    }
    else if (scopeValue == ancscopeValue) {
        scopeName = ancscopeName;
    }
    else if (scopeValue == timingscopeValue) {
        scopeName = timingscopeName;
    }
    else if (scopeValue == audiovectorscopeValue) {
        scopeName = audiovectorscopeName;
    }
    else if (scopeValue == audiophasescopeValue) {
        scopeName = audiophasescopeName;
    }
    else if (scopeValue == audiohistogramscopeValue) {
        scopeName = audiohistogramscopeName;
    }
    else if (scopeValue == 254) {
        scopeName = picturescopeName;
    }
    else if (scopeValue == audiowavescopeValue) {
        scopeName = audiowavescopeName;
    }
    else if (scopeValue == audiometerscopeValue) {
        scopeName = audiometerscopeName;
    }
    else if (scopeValue == audiometerssurroundscopeValue) {
        scopeName = audiometerssurroundscopeName;
    }
    else if (scopeValue == audiometersloudnessscopeValue) {
        scopeName = audiometersloudnessscopeName;
    }
    else if (scopeValue == ycbcrvectorValue) {
        scopeName = ycbcrvectorName;
    }
    else if (scopeValue == channelplotValue) {
        scopeName = channelplotName;
    }
    else if (scopeValue == ycpeakValue) {
        scopeName = ycpeakName;
    }
    else if (scopeValue == threedcolorcubeValue) {
        scopeName = threedcolorcubeName;
    }
    else if (scopeValue == lumapeakValue) {
        scopeName = lumapeakName;
    }
    else if (scopeValue == sixbargamutValue) {
        scopeName = sixbargamutName;
    }
    else if (scopeValue == audiospectrumValue) {
        scopeName = audiospectrumName;
    }
    else if (scopeValue == avsyncValue) {
        scopeName = avsyncName;
    }
    else if (scopeValue == streamInfoValue) {
        scopeName = streamInfoName;
    }

    return scopeName;
}

function scopeNameToDivName(scopeName) {
    var divName = "";
    switch (scopeName) {
        case picturescopeName:
            divName = "div-picture";
            break;
        case vectorscopeName:
            divName = "div-vector";
            break;
        case waveformscopeName:
            divName = "div-waveform";
            break;
        case waveformrgbscopeName:
            divName = "div-waveform-rgb";
            break;
        case histogramscopeName:
            divName = "div-histo";
            break;
        case chromaticityscopeName:
            divName = "div-chroma";
            break;
        case statusscopeName:
            divName = "div-status";
            break;
        case ancscopeName:
            divName = "div-anc";
            break;
        case timingscopeName:
            divName = "div-iptiming";
            break;
        case audiovectorscopeName:
            divName = "div-audio-vector";
            break;
        case audiophasescopeName:
            divName = "div-audio-phase";
            break;
        case audiohistogramscopeName:
            divName = "div-audio-histogram";
            break;
        case audiowavescopeName:
            divName = "div-audio-wave";
            break;
        case audiometerscopeName:
            divName = "div-audio-meter";
            break;
        case audiometerssurroundscopeName:
            divName = "div-audio-metersurround";
            break;
        case audiometersloudnessscopeName:
            divName = "div-audio-meterloudness";
            break;
        case ycbcrvectorName:
            divName = "div-ycbcrvector";
            break;
        case channelplotName:
            divName = "div-channelplot";
            break;
        case ycpeakName:
            divName = "div-ycpeak";
            break;
        case lumaqvectorName:
            divName = "div-lumaqvector";
            break;
        case threedcolorcubeName:
            divName = "div-threedcolorcube";
            break;
        case lumapeakName:
            divName = "div-lumapeak";
            break;
        case sixbargamutName:
            divName = "div-sixbargamut";
            break;
        case audiospectrumName:
            divName = "div-audiospectrum";
            break;
        case avsyncName:
            divName = "div-avsync";
        case streamInfoName:
            divName = "div-streamInfo";
    }

    return divName;
}

function indexToScopeName(index, callback) {
    var x = (index - 1) % 3;
    var y = Math.floor((index - 1) / 3);

    var httpCmd = "drasticcmd?getscope=&x=" + x + "&y=" + y + "&key=getScopes";
    var xhr = getHTTPObject();
    xhr.open("GET", httpCmd);
    xhr.onreadystatechange = function (data) {
        if (xhr.readyState === 4 && xhr.status === 200) {
            //Value of scope name
            var obj = JSON.parse(xhr.responseText);
            let scopeName = scopeValueToName(obj.value);
            callback(scopeName, x, y);
        }
    }.bind(this);
    xhr.send();
}

function setScopeClear() {
    var pictureDiv = document.getElementById("div-picture");
    var vectorDiv = document.getElementById("div-vector");
    var waveformDiv = document.getElementById("div-waveform");
    var waveformRgbDiv = document.getElementById("div-waveform-rgb");
    var histoDiv = document.getElementById("div-histo");
    var chromaDiv = document.getElementById("div-chroma");
    var statusDiv = document.getElementById("div-status");
    var ancDiv = document.getElementById("div-anc");
    var timingDiv = document.getElementById("div-timing");
    var audioVectorDiv = document.getElementById("div-audio-vector");
    var audioPhaseDiv = document.getElementById("div-audio-phase");
    var audioHistoDiv = document.getElementById("div-audio-histogram");
    var audioWaveDiv = document.getElementById("div-audio-wave");
    var audioMeterDiv = document.getElementById("div-audio-meter");
    var audioMetersSurroundDiv = document.getElementById("div-audio-metersurround");
    var audioMetersLoudnessDiv = document.getElementById("div-audio-meterloudness");
    var ycbcrvectorDiv = document.getElementById("div-ycbcrvector");
    var channelplotDiv = document.getElementById("div-channelplot");
    var ycpeakDiv = document.getElementById("div-ycpeak");
    var lumaqvectorDiv = document.getElementById("div-lumaqvector");
    var threedcolorcubeDiv = document.getElementById("div-threedcolorcube");
    var lumapeakDiv = document.getElementById("div-lumapeak");
    var sixbargamutDiv = document.getElementById("div-sixbargamut");
    var audiospectrumDiv = document.getElementById("div-audiospectrum");
    var avsyncDiv = document.getElementById("div-avsync");
    var streamInfoDiv = document.getElementById("div-streamInfo");

    /*if (!pageRefresh) {*/
    pictureDiv.style.display = "none";
    vectorDiv.style.display = "none";
    waveformDiv.style.display = "none";
    waveformRgbDiv.style.display = "none";
    histoDiv.style.display = "none";
    chromaDiv.style.display = "none";
    statusDiv.style.display = "none";
    ancDiv.style.display = "none";
    timingDiv.style.display = "none";
    audioVectorDiv.style.display = "none";
    audioPhaseDiv.style.display = "none";
    audioHistoDiv.style.display = "none";
    audioWaveDiv.style.display = "none";
    audioMeterDiv.style.display = "none";
    audioMetersSurroundDiv.style.display = "none";
    audioMetersLoudnessDiv.style.display = "none";
    ycbcrvectorDiv.style.display = "none";
    channelplotDiv.style.display = "none";
    ycpeakDiv.style.display = "none";
    lumaqvectorDiv.style.display = "none";
    threedcolorcubeDiv.style.display = "none";
    lumapeakDiv.style.display = "none";
    sixbargamutDiv.style.display = "none";
    audiospectrumDiv.style.display = "none";
    avsyncDiv.style.display = "none";
    streamInfoDiv.style.display = "none";
    /*}*/
}

function getSetting(x, y, key, callback) {
    var httpCmd = "drasticcmd?getsetting=&x=" + x + "&y=" + y + "&key=" + key;

    nCurX = x;
    nCurY = y;
    var xhr = getHTTPObject();
    xhr.open("GET", httpCmd);
    xhr.onreadystatechange = function (data) {
        if (xhr.readyState === 4 && xhr.status === 200) {
            // Get nameOfBool from key= elem of xhr.responseURL
            var obj = JSON.parse(xhr.responseText);
            callback(obj.value);
        }
    }.bind(this);
    xhr.send();
}

function setConfigSettings(scopeName, xCoordinate, yCoordinate) {
    var divName = scopeNameToDivName(scopeName);
    var divElement = document.getElementById(divName);
    let checkBoxes = divElement.querySelectorAll("input.checkboxInput.setting-item");
    checkBoxes.forEach(checkbox => {
        getSetting(xCoordinate, yCoordinate, checkbox.id, (value) => { checkbox.checked = value; });
    });

    let dropdowns = divElement.querySelectorAll(".setting-item > select");
    dropdowns.forEach(dropdown => {
        getSetting(xCoordinate, yCoordinate, dropdown.id, (value) => { dropdown.value = value; });
    });
}

function onClickButton(buttonId) {
    var httpCmd = "drasticcmd?setsetting=&x=" + nCurX + "&y=" + nCurY + "&key=" + buttonId;
    var xhr = getHTTPObject();
    // Send command
    var xhr = getHTTPObject();
    xhr.open("GET", httpCmd);
    xhr.onreadystatechange = function () {
        if (xhr.readyState === 4 && xhr.staus === 200) {
            // Done
        }
    }.bind(this);
    xhr.send();
}

function onClickBool(formCheckBox) {
    // Get the id of the checkbox
    var checkboxId = formCheckBox.id;
    var splitString = checkboxId.split('_');
    var checkboxMainId = splitString[0];
    var httpCmd = "drasticcmd?setsetting=&x=" + nCurX + "&y=" + nCurY + "&key=" + checkboxMainId;
    var xhr = getHTTPObject();
    // Build the command string
    if (checkboxId === "black_chroma") {
        if (formCheckBox.checked) {
            httpCmd += "&value=0";
        } else {
            httpCmd += "&value=1";
        }
    } else {
        if (formCheckBox.checked) {
            httpCmd += "&value=1";
        } else {
            httpCmd += "&value=0";
        }
    }
    // Send command
    var xhr = getHTTPObject();
    xhr.open("GET", httpCmd);
    xhr.onreadystatechange = function (nameOfBool) {
        if (xhr.readyState === 4 && xhr.staus === 200) {
            // Done
        }
    }.bind(this);
    xhr.send();
}

function selectScaleType(selectedScaleType) {
	var intValue = 0;
	if (selectedScaleType.value === "DIGITAL") {
		intValue = 0;
	}
	else if (selectedScaleType.value === "IRE") {
		intValue = 1;
	}
	else if (selecteScaleType.value === "MV") {
		intValue = 2;
	}

	setIntValues(intValue, "scaletype");
}

function selectMaxHDR(selectedValue) {
	var intValue = 0;
	if (selectedValue.value === "10k") {
		intValue = 0;
	}
	else if (selectedValue.value === "5k") {
		intValue = 1;
	}
	else if (selectedValue.value === "4k") {
		intValue = 2;
	} 
    else if (selectedValue.value === "3k") {
		intValue = 3;
	}
    else if (selectedValue.value === "2k") {
		intValue = 4;
	}
    else if (selectedValue.value === "1k") {
		intValue = 5;
	}
    else if (selectedValue.value === "200") {
		intValue = 6;
	}

	setIntValues(intValue, "maxhdr");
}


function selectHiLo(selectedHiLoValue) {
	var intValue = 0;
	if (selectedHiLoValue.value === "normal") {
		intValue = 0;
	}
	else if (selectedHiLoValue.value === "zoomTwo") {
		intValue = 1;
	}
	else {
		intValue = 2;
	}

	setIntValues(intValue, "wavehilo");
}

function selectHistoType(selectedHistoType) {
	setIntValues(selectedHistoType.value, "histogramtype");

}

function selectAudSurDisplay(value, id) {
    var surround5 = document.getElementsByClassName("5smpte");
    var surround7 = document.getElementsByClassName("7smpte");

    if(value == 1) {
        for(let i = 0; i < surround5.length; i++) {
            surround5[i].hidden = false;
        }
        for(let i = 0; i < surround7.length; i++) {
            surround7[i].hidden = true;
        }
        var config = document.getElementById("audsurrconfig");
        config.value = 3;
        setIntValues(3,"audsurrconfig");
    }
    if(value == 2) {
        for(let i = 0; i < surround5.length; i++) {
            surround5[i].hidden = true;
        }
        for(let i = 0; i < surround7.length; i++) {
            surround7[i].hidden = false;
        }
        var config = document.getElementById("audsurrconfig");
        config.value = 102;
        setIntValues(102,"audsurrconfig");
    }

    setIntValues(value, id);
}

function setIntValues(intValue, keyValue) {
	setCurXandY();
	var httpCmd = "drasticcmd?setsetting=&x=" + nCurX + "&y=" + nCurY + "&key=" + keyValue + "&value=" + intValue;
	var xhr = getHTTPObject();
	// Send command
	var xhr = getHTTPObject();
	xhr.open("GET", httpCmd);
	xhr.onreadystatechange = function(nameOfBool) {
		if(xhr.readyState === 4 && xhr.staus === 200) {
			// Done
		}
	}.bind(this);
	xhr.send();
}

function auvecRadButtons(selectedRadioBtn) {
    var selectedRadBtn = selectedRadioBtn.value;
    var radVal = 0;
    if (selectedRadBtn === "Lissajousxy") {
        radVal = 0;
    }
    else if (selectedRadBtn === "Lissajous") {
        radVal = 1;
    }
    else if (selectedRadBtn === "Polar") {
        radVal = 2;
    }


    setIntValues(radVal, "audvectortype");
}

function auvecRadButtons(selectedRadioBtn) {
    setIntValues(selectedRadioBtn.value, "syncpostype");
}

function auHistoRadBtnOne(selectedRadioButton) {
    var intValue = 0;
    var selectedRadBtn = selectedRadioButton.value;
    var selectedRadBtnClass = selectedRadioButton.className;

    if (selectedRadBtnClass === "first-set") {
        if (selectedRadBtn === "amplinear") {
            intValue = 0;
        }
        else {
            intValue = 1;
        }

        setIntValues(intValue, "audhistlog");
    }
}

function auHistoRadBtnTwo(selectedRadioButton) {
    var selectedRadioBtn = selectedRadioButton.value;
    var selectedRadBtnVal = 0;
    if (selectedRadioBtn === "scalesqrt") {
        selectedRadBtnVal = 1;
    }
    else if (selectedRadioBtn === "scalecbrt") {
        selectedRadBtnVal = 2;
    }
    else if (selectedRadioBtn === "scalelog") {
        selectedRadBtnVal = 3;
    }
    else if (selectedRadioBtn === "scalerlog") {
        selectedRadBtnVal = 2;
    }
    else selectedRadBtnVal = 0;

    var httpCmd = "drasticcmd?setsetting=&x=" + nCurX + "&y=" + nCurY + "&key=audhistscale&value=" + selectedRadBtnVal;
    var xhr = getHTTPObject();
    xhr.open("GET", httpCmd);
    xhr.onreadystatechange = function() {
        if(xhr.readyState === 4 && xhr.staus === 200) {
            // Done
        }
    }.bind(this);
    xhr.send();
}

function waveSelection(selectedWave) {
    var waveSelection = selectedWave.value;
    var waveVal = 0;
    if (waveSelection === "MV") {
        waveVal = 1;
    }
    else if (waveSelection === "IRE") {
        waveVal = 2;
    }
    else waveVal = 0;

    var httpCmd = "drasticcmd?setsetting=&x=" + nCurX + "&y=" + nCurY + "&key=scaletype" + "&value=" + waveVal;
    var xhr = getHTTPObject();
    xhr.open("GET", httpCmd);
    xhr.onreadystatechange = function() {
        if(xhr.readyState === 4 && xhr.staus === 200) {
            // Done
        }
    }.bind(this);
    xhr.send();
}

function selectionHistoType(selectedHisto) {
    var histoSelection = selectedHisto.value;
    var histoVal = 0;
    if (histoSelection === "RGB") {
        histoVal = 1
    }
    else if (histoSelection === "HSV") {
        histoVal = 2;
    }
    else if (histoSelection === "Luma") {
        histoVal = 3;
    }
    else if (histoSelection === "H/S Scope") {
        histoVal = 4;
    }
    else histoVal = 0;

    var httpCmd = "drasticcmd?setsetting=&x=" + nCurX + "&y=" + nCurY + "&key=histogramtype" + "&value=" + histoVal;
    var xhr = getHTTPObject();
    xhr.open("GET", httpCmd);
    xhr.onreadystatechange = function() {
        if(xhr.readyState === 4 && xhr.staus === 200) {
            // Done
        }
    }.bind(this);
    xhr.send();
}

window.onload = function() {
	//PICTURE - Handling slider for graticule brightness
	var slider1 = document.getElementById("picSliderGrat");
	var sliderOutput1 = document.getElementById("sliderValueGratPic");
	sliderOutput1.innerHTML = slider1.value;
	slider1.oninput = function() {
		sliderOutput1.innerHTML = this.value;
		setIntValues(this.value, "brightness");
	}


	//Vector - Handling sliders for intensity and graticule brightness
	var slider2 = document.getElementById("vecSliderIntensity");
	var sliderOutput2 = document.getElementById("sliderValueIntensityVec");
	sliderOutput2.innerHTML = slider2.value;
	slider2.oninput = function() {
		sliderOutput2.innerHTML = this.value;
		setIntValues(this.value, "intensity");
	}
	var slider3 = document.getElementById("vecSliderGrat");
	var sliderOutput3 = document.getElementById("sliderValueGratVec");
	sliderOutput3.innerHTML = slider3.value;
	slider3.oninput = function() {
		sliderOutput3.innerHTML = this.value;
		setIntValues(this.value, "brightness");
	}


	//WAVEFORM - Handling sliders for intensity and graticule brightness
	var slider4 = document.getElementById("waveSliderIntensity");
	var sliderOutput4 = document.getElementById("sliderValueIntensityWave");
	sliderOutput4.innerHTML = slider4.value;
	slider4.oninput = function() {
		sliderOutput4.innerHTML = this.value;
		setIntValues(this.value, "intensity");
	}
	var slider5 = document.getElementById("waveSliderGrat");
	var sliderOutput5 = document.getElementById("sliderValueGratWave");
	sliderOutput5.innerHTML = slider5.value;
	slider5.oninput = function() {
		sliderOutput5.innerHTML = this.value;
		setIntValues(this.value, "brightness");
	}


	//WAVEFORM RGB - Handling sliders for intensity and graticule brightness
	var slider6 = document.getElementById("wrgbSliderIntensity");
	var sliderOutput6 = document.getElementById("sliderValueIntensityWRGB");
	sliderOutput6.innerHTML = slider6.value;
	slider6.oninput = function() {
		sliderOutput6.innerHTML = this.value;
		setIntValues(this.value, "intensity");
	}
	var slider7 = document.getElementById("wrgbSliderGrat");
	var sliderOutput7 = document.getElementById("sliderValueGratWRGB");
	sliderOutput7.innerHTML = slider7.value;
	slider7.oninput = function() {
		sliderOutput7.innerHTML = this.value;
		setIntValues(this.value, "brightness");
	}


	//HISTOGRAM - Handling slider for graticule brightness
	var slider8 = document.getElementById("histoSliderGrat");
	var sliderOutput8 = document.getElementById("sliderValueGratHisto");
	sliderOutput8.innerHTML = slider8.value;
	slider8.oninput = function() {
		sliderOutput8.innerHTML = this.value;
		setIntValues(this.value, "brightness");
	}


	//CHROMATICITY - Handling slider for graticule brightness
	var slider9 = document.getElementById("chromaSliderGrat");
	var sliderOutput9 = document.getElementById("sliderValueGratChroma");
	sliderOutput9.innerHTML = slider9.value;
	slider9.oninput = function() {
		sliderOutput9.innerHTML = this.value;
		setIntValues(this.value, "brightness");
	}


	//STATUS - Handling slider for graticule brightness
	var slider10 = document.getElementById("statusSliderGrat");
	var sliderOutput10 = document.getElementById("sliderValueGratStatus");
	sliderOutput10.innerHTML = slider10.value;
	slider10.oninput = function() {
		sliderOutput10.innerHTML = this.value;
		setIntValues(this.value, "brightness");
	}


	//AUDIO VECTOR - Handling slider for graticule brightness
	var slider10 = document.getElementById("auvecSliderGrat");
	var sliderOutput10 = document.getElementById("sliderValueGratAuVec");
	sliderOutput10.innerHTML = slider10.value;
	slider10.oninput = function() {
		sliderOutput10.innerHTML = this.value;
		setIntValues(this.value, "brightness");
	}


	//AUDIO PHASE - Handling slider for graticule brightness
	var slider11 = document.getElementById("auphaseSliderGrat");
	var sliderOutput11 = document.getElementById("sliderValueGratAuPhase");
	sliderOutput11.innerHTML = slider11.value;
	slider11.oninput = function() {
		sliderOutput11.innerHTML = this.value;
		setIntValues(this.value, "brightness");
	}


	//AUDIO HISTOGRAM - Handling slider for graticule brightness
	var slider12 = document.getElementById("auhistoSliderGrat");
	var sliderOutput12 = document.getElementById("sliderValueGratAuHisto");
	sliderOutput12.innerHTML = slider12.value;
	slider12.oninput = function() {
		sliderOutput12.innerHTML = this.value;
		setIntValues(this.value, "brightness");
	}

	//AUDIO WAVE - Handling slider for graticule brightness
	var slider13 = document.getElementById("auwaveSliderGrat");
	var sliderOutput13 = document.getElementById("sliderValueGratAuWave");
	sliderOutput13.innerHTML = slider13.value;
	slider13.oninput = function() {
		sliderOutput13.innerHTML = this.value;
		setIntValues(this.value, "brightness");
	}
}

var positionOfScope = "";
var nCurX = 0;
var nCurY = 0;

function setCurXandY() {
	if(positionOfScope != ""){
		if (positionOfScope === "scope-one") {
			nCurX = 0;
			nCurY = 0;
		}
		else if (positionOfScope === "scope-two") {
			nCurX = 1;
			nCurY = 0;
		}
		else if (positionOfScope === "scope-three") {
			nCurX = 2;
			nCurY = 0;
		}
		else if (positionOfScope === "scope-four") {
			nCurX = 0;
			nCurY = 1;
		}
		else if (positionOfScope === "scope-five") {
			nCurX = 1;
			nCurY = 1;
		}
		else if (positionOfScope === "scope-six") {
			nCurX = 2;
			nCurY = 1;
		}
	}
}

function syncGetPosType(x, y, key) {
    	setCurXandY();
		var httpCmd = "drasticcmd?getsetting=&x=" + x + "&y=" + y + "&key=" + key;

		nCurX = x;
		nCurY = y;
		var xhr = getHTTPObject();
		xhr.open("GET", httpCmd);
		xhr.onreadystatechange = function(data) {
			if(xhr.readyState === 4 && xhr.status === 200) {
				// Get nameOfBool from key= elem of xhr.responseURL
				var absButton = document.getElementById("avsyncabsolute");
                var percButton =  document.getElementById("avsyncpercent");
				// Parse xhr json return for value
				var obj = JSON.parse(xhr.responseText);
				if(obj.value) {
					absButton.checked = true;
				} else {
					percButton.checked = true;
				}
			}
		}.bind(this);
		xhr.send();
}



function syncGetPattern(x, y, key) {
    	setCurXandY();
		var httpCmd = "drasticcmd?getsetting=&x=" + x + "&y=" + y + "&key=" + key;

		nCurX = x;
		nCurY = y;
		var xhr = getHTTPObject();
		xhr.open("GET", httpCmd);
		xhr.onreadystatechange = function(data) {
			if(xhr.readyState === 4 && xhr.status === 200) {
				// Get nameOfBool from key= elem of xhr.responseURL
				var combo = document.getElementById("syncpattern");
				// Parse xhr json return for value
				var obj = JSON.parse(xhr.responseText);
				if(obj.value == 0x01000000)
					combo.value = 0;
                if(obj.value == 0x02000000)
					combo.value = 1;
                if(obj.value == 0x05000000)
					combo.value = 2;
                if(obj.value == 0x01000000)
					combo.value = 3;
                if(obj.value == 0x23000000)
					combo.value = 4;
                if(obj.value == 0x24000000)
					combo.value = 5;
                if(obj.value == 0x10000000)
					combo.value = 6;
                if(obj.value == 0x11000000)
					combo.value = 7;
                if(obj.value == 0x13000000)
					combo.value = 8;
                if(obj.value == 0x12000000)
					combo.value = 9;
                if(obj.value == 0x15000000)
					combo.value = 10;
                if(obj.value == 0x20000000)
					combo.value = 11;
                if(obj.value == 0x17000000)
					combo.value = 12;
                if(obj.value == 0x19000000)
					combo.value = 13;
                if(obj.value == 0x14000000)
					combo.value = 14;
                if(obj.value == 0x22000000)
					combo.value = 15;
                if(obj.value == 0x18000000)
					combo.value = 16;
                if(obj.value == 0x21000000)
					combo.value = 17;
                if(obj.value == 0x16000000)
					combo.value = 18;
			
			}
		}.bind(this);
		xhr.send();
}